<?PHP 
	$this->load->helper('form_helper');
	$this->load->view('header/header');
	$this->load->view('message_modal');
?>
			<a class="hidden_context hidden_link" name="menuContent" id="menuContent">Menu</a>
			<a class="hidden_context hidden_link" name="menuContent" id="skipMenu" href="#mailboxListContent">Skip Menu</a>
            <div id="menu">
                <div id="menuwrap">
                    <button class="minimal minimal-short" type="button" id="get_mail_btn" onclick="ajaxMessageCheck(this);">Get Mail</button>
                    <button type="submit" class="minimal minimal-short" id="archive_btn" name="archive" disabled="disabled" aria-hidden="true" style="width: 135px;">Archive Message</button>
					<input type="submit" class="hidden_context" name="archive_hidden" id="archive_hidden" value="Archive" />
					<?PHP echo form_hidden('last_button', $this->session->flashdata('last_button'), 'last_button'); ?>
					<label for="move_select" class="hidden_context">Select Mailbox for Move</label>
					<select name="move_select" id="move_select" class="hidden_context">
					<?PHP
						foreach(json_decode($json_mailbox_list) as $mailbox) {
							echo '<option value="'. $mailbox->link .'">' . $mailbox->label . '</option>'; 
						}
					?>
					</select>
					<input type="submit" name="move_hidden" id="move_hidden" class="hidden_context" value="Move" />
                    <button type="button" class="minimal minimal-short" id="move_btn" name="move" disabled="disabled" aria-hidden="true">Move</button>
					<input type="submit"  style="display:none;" id="mark_as_read_btn" name="mark_as_read" aria-hidden="true" />
					<input type="submit"  style="display:none;" id="mark_as_read_unbtn" name="mark_as_unread" aria-hidden="true" />
					<input type="submit" class="hidden_context" name="mark_as_read_hidden" id="mark_as_read_hidden" value="Mark as Read" />
					<input type="submit" class="hidden_context" name="mark_as_unread_hidden" id="mark_as_unread_hidden" value="Mark as Unread" />
					<button type="button" data-dropdown="#dropdown-1" class="minimal minimal-short" title="More menu" id="more_button"  name="more_button" disabled="disabled" aria-hidden="true">More &#x25BE;</button>
					<div id="dropdown-1" class="dropdown dropdown-tip dropdown-relative dropdown-anchor-right">
						<ul class="dropdown-menu">
							<li><a onclick="$('#mark_as_read_btn').trigger('click');" href="#">Mark as read</a></li>
							<li><a onclick="$('#mark_as_read_unbtn').trigger('click');" href="#">Mark as unread</a></li>
						</ul>
					</div>
                    <?PHP if(isset($pagination)) { echo "<div id=\"pagination\">" . $pagination . "</div>"; } ?>
                </div>
            </div>
        </div>
            <div id="header_padding"></div>
            <?PHP 
                $message = $this->session->userdata("message");
                $this->session->unset_userdata("message");
                if(isset($message) && strlen($message) > 0) { echo $message; } 
            ?>
			
			<div id="mailbox_wrapper">
				<a name="mailboxListContent" id="mailboxListContent" class="hidden_context hidden_link">Mailbox List</a>
				<a class="hidden_context hidden_link" href="#mainContent" id="skipMailboxList">Skip Mailbox List</a>
				<div id="mailboxes">
					<button class="minimal" type="button" id="compose_btn" name="compose" onclick="document.location.href='<?PHP echo base_url(). "inbox/compose"; ?>';">Compose</button>
					<br /><br />
					<h2 class="hidden_context">Mailbox Folder Menu</h2>
					<?PHP if(isset($mailboxes)) { echo $mailboxes; } ?>
				</div>
				<a class="hidden_context hidden_link" href="#menuContent" id="skipToMenu">Skip to Menu</a>
			</div>
			<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
			<h2 class="hidden_context">Message List</h2>
            <div id="msg_pane">
            <?PHP 
                //if viewing list of messages
                if(isset($headers) && is_string($headers)) { 
                    $decode = json_decode($headers); 
                    if(!is_null($decode)) { $headers = $decode; }
                }
                if(isset($headers) && !empty($headers) && (is_object($headers) || is_array($headers)) && $connected) {
                    if(isset($search_message)) { echo "<h3>" . $search_message . "</h3>"; }
					if(isset($_SESSION['mailbox'])) { $mailbox = $_SESSION['mailbox']; } else { $mailbox = 'INBOX'; }
                    echo '<table id="messages" style="border-spacing: 1px;"' .
						 ' summary="This table lists messages in the ' . $mailbox .  ' folder.' .
						 ' Each row contains a checkbox for selecting an individual message to perform an action, such as Archive, Move, or Mark as Read.' .
						 ' Each table cell after the checkbox contains information about the message: The sender of the message, the subject (and the priority if applicable), the date it was sent, and the message size.">';
					echo '<caption class="hidden_context">List of messages in mailbox folder: ' . $mailbox . '</caption>';
					echo '<!--[if lte IE 8 ]>';
						echo '<colgroup span="8">';
							echo '<col style="width: 40px;">';
							echo '<col style="width: 40px;">';
							echo '<col style="width: 100px;">';
							echo '<col style="width: 100px;">';
							echo '<col style="width: 290px;">';
							echo '<col style="width: 50px;">';
							echo '<col style="width: 80px;">';
							echo '<col style="width: 50px;">';
						echo '</colgroup>';
					echo '<![endif]-->';
                   echo '<tr class="header">';
						echo '<th scope="col" class="select">';
							echo '<label for="selectall" style="display: none;">Select All</label>';
							echo '<input type="checkbox" name="selectall" id="selectall" onclick="selectAll()" />';
						echo '</th>';
						echo '<th scope="col" class="attachment"><img src="/images/paperclip.png" style="height: 15px;" alt="Has Attachment" title="Attachment" /></th>';
						echo '<th scope="col" class="sender group">From</th>';
						echo '<th scope="col" class="recipient group">To</th>';
						echo '<th scope="col" class="subject group">Subject</th>';
						echo '<th scope="col" class="priority">Priority</th>';
						echo '<th scope="col" class="date">Date</th>';
						echo '<th scope="col" class="size">Size</th>';
					echo '</tr>';
                    foreach($headers as $header) {
                        $header = (object)$header;
                        $msg_id = trim($header->Msgno);
                        $msg_uid = trim($header->uid);

                        //format header to utf-8, or set to No Subject if blank
                        if(isset($header->subject) && strlen(trim(imap_utf8($header->subject))) > 0) { $subject = htmlentities(imap_utf8($header->subject)); }
                        else { $subject = "(No Subject)"; }
	
                        $date = date("n/j/Y",$header->udate); //format date from unix date
                        if($date == date("n/j/Y")) { $date = date("h:i A",$header->udate); } //if date is current date, use time
						$date = htmlentities($date); //format for html display
						
						
						//format From address, will look for personal name before just displaying address
						$from = '';
                        if(isset($header->from)) {
                            if(isset($header->from[0]->personal)) { $from = $header->from[0]->personal; }
                            else { 
                                if(isset($header->from[0]->mailbox) && isset($header->from->host)) {
                                    $from = $header->from[0]->mailbox . "@" . $header->from[0]->host; 
                                }
                                else if(isset($header->from[0]->mailbox)) { $from = $header->from[0]->mailbox; }
                                else if(isset($header->from[0]->host)) { $from = $header->from[0]->host; }
                            }
                        }
						$from = htmlentities($from); //encode to display within html
						
                        //format To address, will look for personal name before just displaying address
						$to = '';
                        if(isset($header->to)) {
                            if(isset($header->to[0]->personal)) { $to= $header->to[0]->personal; }
                            else { 
                                if(isset($header->to[0]->mailbox) && isset($header->to->host)) {
                                    $to = $header->to[0]->mailbox . "@" . $header->to[0]->host; 
                                }
                                else if(isset($header->to[0]->mailbox)) { $to = $header->to[0]->mailbox; }
                                else if(isset($header->to[0]->host)) { $to = $header->to[0]->host; }
                            }
                        }
						$to = htmlentities($to); //encode to display within html
						
                        $size = round(($header->Size/1024),0);	$size_units = "KB";
                        if($size >= 1000) { $size = round($size/1024,1); $size_units = "MB"; }
                        if($size >= 1000) { $size = round($size/1024,1); $size_units = "GB"; }
						$size = htmlentities($size); //format for html display
						
						$attach_icon = '';
                        if(isset($header->has_attach) && $header->has_attach) { $attach_icon =  "<img src=\"/images/paperclip.png\" style=\"height: 15px;\" alt=\"Attachment Icon\" />"; }
					
                        if(isset($header->xpriority)) { 
                            if($header->xpriority < 3) { $priority = "<span title=\"High Priority\" class=\"high_priority\">!</span>"; }
                            else if($header->xpriority == 3) { $priority = "";}
                            else if($header->xpriority > 3) { $priority = "<span title=\"Low Priority\" class=\"low_priority\">&#8595;</span>"; }
                            else { $priority = ""; }
                        }
                        else if(isset($header->importance)) { 
                            if(strtolower($header->importance) == "high") { $priority = "<span title=\"High Priority\" class=\"high_priority\">!</span>"; }
                            else if(strtolower($header->importance) == "low") { $priority = "<span title=\"Low Priority\" class=\"low_priority\">&#8595;</span>"; }
                            else { $priority = ""; }
                        }
                        else { $priority = ""; }
                        //make message bold if the message is new
                        if($header->Unseen == "U") { $class = "class=\"newmsg\""; }
                        else { $class = ""; }

                        echo '<tr>';
							echo '<td>';
								echo '<label for="select' . $msg_uid . '" style="display: none;">Select Message with Subject: ' . $subject . '</label>';
								echo '<input class="selectmsg" type="checkbox" name="select' . $msg_uid . '" id="select' . $msg_uid . '" onclick="selectMsg(this)" />';
							echo '</td>';
							echo '<td>';
								if(isset($attach_icon)) { echo '<a '. $class . ' href="' . base_url() . 'inbox/viewmsg' . '/' . $msg_id . '/">'. $attach_icon .'</a>'; }
							echo '</td>';
							echo '<td>';
								echo '<div class="sender group">';
									echo '<a '. $class . ' id="sender" title="'.$from.'" href="' . base_url() . 'inbox/viewmsg' . '/' . $msg_id . '/">' . $from . '</a>';
								echo '</div>';
							echo '</td>';
							echo '<td>';
								echo '<div class="recipient group">';
									echo '<a '. $class . ' id="sender" title="'.$to.'" href="' . base_url() . 'inbox/viewmsg' . '/' . $msg_id . '/">' . $to . '</a>';
								echo '</div>';
							echo '</td>';
							echo '<td>';
								echo '<div class="subject group">';
									echo '<a '. $class . ' id="subject" title="'.$subject.'" href="' . base_url() . 'inbox/viewmsg' . '/' . $msg_id . '/">' . $subject . '</a>';
								echo '</div>';
								echo $this->load->view('inbox/_flag', compact('header', 'msg_uid'), TRUE);
							echo '</td>';
							echo '<td><a '. $class . ' id="priority" style="text-align:center;" href="' . base_url() . 'inbox/viewmsg' . '/' . $msg_id . '/">' . $priority . '</a></td>';
							echo '<td class="date">';
								echo '<a '. $class . ' href="' . base_url() . 'inbox/viewmsg' . '/' . $msg_id . '/">' . $date . '</a>';
							echo '</td>';
							echo '<td>';
								echo '<a '. $class . ' href="' . base_url() . 'inbox/viewmsg' . '/' . $msg_id . '/">' . $size . $size_units . '</a>';
							echo '</td>';
						echo '</tr>';

                    }
                    echo "</table>";
                }
                else {
                    echo "<div id=\"msgbody\">" . $headers . "</div>";
                }
            ?>
            </div>
			
        <?PHP echo form_close(); ?>
    </div>
    <?PHP $this->load->view("footer"); ?>
	</body>
</html>
